##
## political terror scale (PTS)
##

load("Daten/Political Terror Scale 1976-2012/PTS2012.RData")
#PTS$Country[PTS$Country=="Serbia"] <- "Yugoslavia"
PTS$COWAlpha[PTS$COWAlpha=="W. Germany"] <- "GMY"
PTS$actorid <- countrycode(PTS$COWAlpha, "cowc", "cown", warn = T)

PTS$max_pts <- apply(PTS[c("Amnesty", "StateDept")], 1, max, na.rm=T)
PTS$max_pts[is.infinite(PTS$max_pts) | is.nan(PTS$max_pts)] <- NA
PTS <- rename(PTS, c("Year"="year"), warn_missing = T)

PTS <- subset(PTS, year > 1988 & year < 2010, c(actorid, year, max_pts))
PTS <- PTS[!is.na(PTS$actorid),]
PTS <- PTS[!duplicated(PTS[c("actorid", "year")]),]

Master <- join(Master, PTS, type="left", by=c("actorid", "year"), match="all")


##
## other forms of political violence / CIRI data
##
CIRI <- read.csv(file = "Daten/CIRI Human Rights Data//CIRI Data 1981_2011 2014.04.14.csv", 
                 header = T, sep = ",")
CIRI <- subset(CIRI, select = c(YEAR, POLITY, PHYSINT, DISAP, KILL, POLPRIS, TORT))
CIRI <- rename(CIRI, c("YEAR" = "year", "POLITY" = "actorid", "PHYSINT" = "ciri_physint", "DISAP" = "ciri_disap",
                       "KILL" = "ciri_kill", "POLPRIS" = "ciri_polpris", "TORT" = "ciri_tort"))

# recode physint [0;8]
# 0=full government respect for these four rights)
# 8=no government respect for these four rights
CIRI$ciri_physint <- recode(CIRI$ciri_physint,"0=8;1=7;2=6;3=5;4=4;5=3;6=2;7=1;8=0")
# recode all others [0;2]
# 0=did not occur in a given year
# 1=occasionally occurred in a given year
# 2=have occurred frequently in a given year
CIRI$ciri_disap <- recode(CIRI$ciri_disap, "0=2;1=1;2=0")
CIRI$ciri_kill <- recode(CIRI$ciri_kill, "0=2;1=1;2=0")
CIRI$ciri_polpris <- recode(CIRI$ciri_polpris, "0=2;1=1;2=0")
CIRI$ciri_tort <- recode(CIRI$ciri_tort, "0=2;1=1;2=0")

# from dplyr help: << type="left": all rows in x, adding matching columns from y >>
Master <- join(Master, CIRI, type="left", by=c("actorid", "year"), match="all")
# define missing values
Master$ciri_disap[Master$ciri_disap=="-999" | Master$ciri_disap=="-77" | Master$ciri_disap=="-66"] <- NA 
Master$ciri_kill[Master$kill=="-999" | Master$ciri_kill=="-77" | Master$ciri_kill=="-66"] <- NA 
Master$ciri_polpris[Master$ciri_polpris=="-999" | Master$ciri_polpris=="-77" | Master$ciri_polpris=="-66"] <- NA 
Master$ciri_tort[Master$ciri_tort=="-999" | Master$ciri_tort=="-77" | Master$ciri_tort=="-66"] <- NA 


##
## One-sided violence (UCDP data)
##
load("Daten/UCDP One-sided Violence Dataset v 1.4-2014/124932_1ucdpone-sidedviolencedataset.1.4-2014.rdata")
ucdpOneSided <- subset(ucdpOneSided, select = c(Year, ActorId, BestFatalityEstimate))
ucdpOneSided <- rename(ucdpOneSided, c("Year" = "year", "ActorId" = "actorid", "BestFatalityEstimate" = "OneSided"))
ucdpOneSided <- ucdpOneSided[order(ucdpOneSided$actorid, ucdpOneSided$year),]

# from dplyr help: << type="left": all rows in x, adding matching columns from y >>
Master <- join(Master, ucdpOneSided, type="left", by=c("actorid", "year"), match="all")
Master$OneSided[is.na(Master$OneSided)] <- 0 # replace all NA with 0 (no report = no one-sided violence; don't loose cases)

rm(ucdpOneSided, CIRI, PTS)
